/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.core.io.vfs;

import com.aptana.core.io.vfs.ExtendedFileInfo;
import com.aptana.core.io.vfs.IConnectionFileManager;
import com.aptana.core.io.vfs.IExtendedFileInfo;
import com.aptana.core.io.vfs.Messages;
import com.aptana.core.io.vfs.Policy;
import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.ExpiringMap;
import com.aptana.core.util.ProgressMonitorInterrupter;
import com.aptana.ide.core.io.CoreIOPlugin;
import com.aptana.ide.core.io.InfiniteProgressMonitor;
import com.aptana.ide.core.io.PermissionDeniedException;
import com.aptana.ide.core.io.preferences.PermissionDirection;
import com.aptana.ide.core.io.preferences.PreferenceUtils;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;

public abstract class BaseConnectionFileManager
implements IConnectionFileManager {
    protected static final int CACHE_TTL = 60000;
    private static final int RETRIES_AFTER_FAILURE = 2;
    protected static final char[] EMPTY_PASSWORD = "".toCharArray();
    protected static final String[] EMPTY_STRING_ARRAY = new String[0];
    protected static final byte[] EMPTY_BYTES = new byte[0];
    protected static final IExtendedFileInfo[] EMPTY_FILEINFO_ARRAY = new IExtendedFileInfo[0];
    protected String login;
    protected char[] password = EMPTY_PASSWORD;
    protected IPath basePath;
    protected String authId;
    private Map<IPath, ExtendedFileInfo> fileInfoCache;
    private Map<IPath, ExtendedFileInfo[]> fileInfosCache;
    private final ProgressMonitorInterrupter.InterruptDelegate interruptDelegate = new ProgressMonitorInterrupter.InterruptDelegate(){

        public void interrupt() {
            BaseConnectionFileManager.this.interruptOperation();
        }
    };

    protected final void promptPassword(String title, String message) {
        this.password = CoreIOPlugin.getAuthenticationManager().promptPassword(this.authId, this.login, title, message);
        if (this.password == null) {
            this.password = EMPTY_PASSWORD;
            throw new OperationCanceledException();
        }
    }

    protected final void getOrPromptPassword(String title, String message) {
        this.password = CoreIOPlugin.getAuthenticationManager().getPassword(this.authId);
        if (this.password == null) {
            this.password = EMPTY_PASSWORD;
            this.promptPassword(title, message);
        }
    }

    protected final void setCaching(boolean enabled) {
        if (this.fileInfoCache != null == enabled) {
            return;
        }
        if (enabled) {
            this.fileInfoCache = new ExpiringMap(60000L);
            this.fileInfosCache = new ExpiringMap(60000L);
        } else {
            this.fileInfoCache = null;
            this.fileInfosCache = null;
        }
    }

    public final synchronized IExtendedFileInfo fetchInfo(IPath path, int options, IProgressMonitor monitor) throws CoreException {
        monitor = Policy.monitorFor(monitor);
        monitor.beginTask(MessageFormat.format(Messages.BaseConnectionFileManager_gethering_details, path.toPortableString()), 2);
        try {
            ProgressMonitorInterrupter.setCurrentThreadInterruptDelegate((ProgressMonitorInterrupter.InterruptDelegate)this.interruptDelegate);
            ExtendedFileInfo fileInfo = this.getCachedFileInfo(path);
            if (fileInfo == null) {
                this.testOrConnect(monitor);
                fileInfo = this.fetchAndCacheFileInfo(path, options, monitor);
                this.setLastOperationTime();
            }
            IExtendedFileInfo iExtendedFileInfo = (IExtendedFileInfo)fileInfo.clone();
            return iExtendedFileInfo;
        }
        finally {
            ProgressMonitorInterrupter.setCurrentThreadInterruptDelegate(null);
            monitor.done();
        }
    }

    public final synchronized String[] childNames(IPath path, int options, IProgressMonitor monitor) throws CoreException {
        monitor = Policy.monitorFor(monitor);
        monitor.beginTask(MessageFormat.format(Messages.BaseConnectionFileManager_listing_directory, path.toPortableString()), 2);
        try {
            ProgressMonitorInterrupter.setCurrentThreadInterruptDelegate((ProgressMonitorInterrupter.InterruptDelegate)this.interruptDelegate);
            ExtendedFileInfo[] fileInfos = this.getCachedFileInfos(path);
            if (fileInfos != null) {
                ArrayList<String> list = new ArrayList<String>();
                ExtendedFileInfo[] extendedFileInfoArray = fileInfos;
                int n = fileInfos.length;
                int n2 = 0;
                while (n2 < n) {
                    ExtendedFileInfo fileInfo = extendedFileInfoArray[n2];
                    list.add(fileInfo.getName());
                    ++n2;
                }
                String[] stringArray = list.toArray(new String[list.size()]);
                return stringArray;
            }
            this.testOrConnect(monitor);
            String[] result = this.listDirectory(this.basePath.append(path), monitor);
            this.setLastOperationTime();
            String[] stringArray = result;
            return stringArray;
        }
        catch (FileNotFoundException e) {
            this.setLastOperationTime();
            String[] stringArray = EMPTY_STRING_ARRAY;
            return stringArray;
        }
        finally {
            ProgressMonitorInterrupter.setCurrentThreadInterruptDelegate(null);
            monitor.done();
        }
    }

    public final synchronized IExtendedFileInfo[] childInfos(IPath path, int options, IProgressMonitor monitor) throws CoreException {
        monitor = Policy.monitorFor(monitor);
        monitor.beginTask(MessageFormat.format(Messages.BaseConnectionFileManager_gethering_details, path.toPortableString()), 2);
        options &= 0x400;
        try {
            ProgressMonitorInterrupter.setCurrentThreadInterruptDelegate((ProgressMonitorInterrupter.InterruptDelegate)this.interruptDelegate);
            ExtendedFileInfo[] fileInfos = this.getCachedFileInfos(path);
            if (fileInfos == null) {
                this.testOrConnect(monitor);
                try {
                    ExtendedFileInfo[] extendedFileInfoArray = fileInfos = this.cache(path, this.fetchFilesInternal(this.basePath.append(path), options, monitor));
                    int n = fileInfos.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ExtendedFileInfo fileInfo = extendedFileInfoArray[n2];
                        this.postProcessFileInfo(fileInfo, this.basePath.append(path), options, monitor);
                        this.cache(path.append(fileInfo.getName()), fileInfo);
                        ++n2;
                    }
                    this.setLastOperationTime();
                }
                catch (FileNotFoundException e) {
                    this.setLastOperationTime();
                    IExtendedFileInfo[] iExtendedFileInfoArray = EMPTY_FILEINFO_ARRAY;
                    ProgressMonitorInterrupter.setCurrentThreadInterruptDelegate(null);
                    monitor.done();
                    return iExtendedFileInfoArray;
                }
                catch (PermissionDeniedException e) {
                    this.setLastOperationTime();
                    throw new CoreException((IStatus)new Status(4, "com.aptana.core.io", MessageFormat.format(Messages.BaseConnectionFileManager_PermissionDenied0, path.toPortableString()), (Throwable)e));
                }
            }
            IExtendedFileInfo[] iExtendedFileInfoArray = (IExtendedFileInfo[])fileInfos.clone();
            return iExtendedFileInfoArray;
        }
        finally {
            ProgressMonitorInterrupter.setCurrentThreadInterruptDelegate(null);
            monitor.done();
        }
    }

    public final synchronized InputStream openInputStream(IPath path, int options, IProgressMonitor monitor) throws CoreException {
        monitor = Policy.monitorFor(monitor);
        monitor.beginTask(MessageFormat.format(Messages.BaseConnectionFileManager_opening_file, path.toPortableString()), 3);
        try {
            ProgressMonitorInterrupter.setCurrentThreadInterruptDelegate((ProgressMonitorInterrupter.InterruptDelegate)this.interruptDelegate);
            this.testOrConnect(monitor);
            ExtendedFileInfo fileInfo = this.fetchAndCacheFileInfo(path, Policy.subMonitorFor(monitor, 1));
            this.setLastOperationTime();
            if (!fileInfo.exists()) {
                throw new CoreException((IStatus)new Status(4, "com.aptana.core.io", Messages.BaseConnectionFileManager_no_such_file, (Throwable)BaseConnectionFileManager.initFileNotFoundException(path, null)));
            }
            if (fileInfo.isDirectory()) {
                throw new CoreException((IStatus)new Status(4, "com.aptana.core.io", Messages.BaseConnectionFileManager_file_is_directory, (Throwable)BaseConnectionFileManager.initFileNotFoundException(path, null)));
            }
            if (fileInfo.getLength() == 0L) {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(EMPTY_BYTES);
                return byteArrayInputStream;
            }
            ProgressMonitorInterrupter.setCurrentThreadInterruptDelegate(null);
            InputStream inputStream = this.readFile(this.basePath.append(path), Policy.subMonitorFor(monitor, 1));
            return inputStream;
        }
        catch (FileNotFoundException e) {
            ProgressMonitorInterrupter.setCurrentThreadInterruptDelegate(null);
            this.setLastOperationTime();
            throw new CoreException((IStatus)new Status(4, "com.aptana.core.io", Messages.BaseConnectionFileManager_no_such_file, (Throwable)BaseConnectionFileManager.initFileNotFoundException(path, e.getCause())));
        }
        catch (CoreException e) {
            ProgressMonitorInterrupter.setCurrentThreadInterruptDelegate(null);
            throw e;
        }
        finally {
            monitor.done();
        }
    }

    public final synchronized OutputStream openOutputStream(IPath path, int options, IProgressMonitor monitor) throws CoreException {
        monitor = Policy.monitorFor(monitor);
        monitor.beginTask(MessageFormat.format(Messages.BaseConnectionFileManager_opening_file, path.toPortableString()), 3);
        try {
            ProgressMonitorInterrupter.setCurrentThreadInterruptDelegate((ProgressMonitorInterrupter.InterruptDelegate)this.interruptDelegate);
            this.testOrConnect(monitor);
            ExtendedFileInfo fileInfo = this.fetchAndCacheFileInfo(path, Policy.subMonitorFor(monitor, 1));
            this.setLastOperationTime();
            if (fileInfo.exists() && fileInfo.isDirectory()) {
                throw new CoreException((IStatus)new Status(4, "com.aptana.core.io", Messages.BaseConnectionFileManager_file_is_directory, (Throwable)BaseConnectionFileManager.initFileNotFoundException(path, null)));
            }
            long permissions = -1L;
            boolean useTemporary = this.canUseTemporaryFile(path, fileInfo, Policy.subMonitorFor(monitor, 1));
            if (fileInfo.exists()) {
                if (useTemporary) {
                    permissions = fileInfo.getPermissions();
                }
            } else if (PreferenceUtils.getUpdatePermissions(PermissionDirection.UPLOAD) && PreferenceUtils.getSpecificPermissions(PermissionDirection.UPLOAD)) {
                permissions = PreferenceUtils.getFilePermissions(PermissionDirection.UPLOAD);
            }
            this.clearCache(path);
            ProgressMonitorInterrupter.setCurrentThreadInterruptDelegate(null);
            OutputStream outputStream = this.writeFile(this.basePath.append(path), useTemporary, permissions, Policy.subMonitorFor(monitor, 1));
            return outputStream;
        }
        catch (FileNotFoundException e) {
            ProgressMonitorInterrupter.setCurrentThreadInterruptDelegate(null);
            this.setLastOperationTime();
            throw new CoreException((IStatus)new Status(4, "com.aptana.core.io", Messages.BaseConnectionFileManager_parent_doesnt_exist, (Throwable)BaseConnectionFileManager.initFileNotFoundException(path, e.getCause())));
        }
        catch (CoreException e) {
            ProgressMonitorInterrupter.setCurrentThreadInterruptDelegate(null);
            throw e;
        }
        finally {
            monitor.done();
        }
    }

    public final synchronized void delete(IPath path, int options, IProgressMonitor monitor) throws CoreException {
        monitor = Policy.monitorFor(monitor);
        monitor = new InfiniteProgressMonitor((IProgressMonitor)monitor);
        monitor.beginTask(Messages.BaseConnectionFileManager_deleting, 20);
        try {
            ProgressMonitorInterrupter.setCurrentThreadInterruptDelegate((ProgressMonitorInterrupter.InterruptDelegate)this.interruptDelegate);
            this.testOrConnect((IProgressMonitor)monitor);
            ExtendedFileInfo fileInfo = this.getCachedFileInfo(path);
            if (fileInfo == null) {
                fileInfo = this.fetchAndCacheFileInfo(path, 2048, Policy.subMonitorFor(monitor, 1));
            }
            if (!fileInfo.exists()) {
                return;
            }
            Policy.checkCanceled(monitor);
            try {
                try {
                    if (fileInfo.isDirectory()) {
                        this.deleteDirectory(this.basePath.append(path), (IProgressMonitor)monitor);
                    } else {
                        this.deleteFile(this.basePath.append(path), (IProgressMonitor)monitor);
                    }
                    this.setLastOperationTime();
                }
                catch (FileNotFoundException ignore) {
                    this.setLastOperationTime();
                    this.clearCache(path);
                }
            }
            finally {
                this.clearCache(path);
            }
        }
        finally {
            ProgressMonitorInterrupter.setCurrentThreadInterruptDelegate(null);
            monitor.done();
        }
    }

    public final synchronized void mkdir(IPath path, int options, IProgressMonitor monitor) throws CoreException {
        monitor = Policy.monitorFor(monitor);
        monitor.beginTask(MessageFormat.format(Messages.BaseConnectionFileManager_creating_folder, path.toPortableString()), 3);
        try {
            ProgressMonitorInterrupter.setCurrentThreadInterruptDelegate((ProgressMonitorInterrupter.InterruptDelegate)this.interruptDelegate);
            this.testOrConnect(monitor);
            ExtendedFileInfo fileInfo = this.fetchAndCacheFileInfo(path, 2048, Policy.subMonitorFor(monitor, 1));
            this.setLastOperationTime();
            if (fileInfo.exists()) {
                if (!fileInfo.isDirectory()) {
                    throw new CoreException((IStatus)new Status(4, "com.aptana.core.io", Messages.BaseConnectionFileManager_file_already_exists, (Throwable)BaseConnectionFileManager.initFileNotFoundException(path, null)));
                }
                return;
            }
            try {
                if ((options & 4) != 0 && path.segmentCount() > 1) {
                    fileInfo = this.fetchAndCacheFileInfo(path.removeLastSegments(1), 2048, Policy.subMonitorFor(monitor, 1));
                    this.setLastOperationTime();
                    if (!fileInfo.exists()) {
                        throw new CoreException((IStatus)new Status(4, "com.aptana.core.io", Messages.BaseConnectionFileManager_parent_doesnt_exist, (Throwable)BaseConnectionFileManager.initFileNotFoundException(path, null)));
                    }
                    if (!fileInfo.isDirectory()) {
                        throw new CoreException((IStatus)new Status(4, "com.aptana.core.io", Messages.BaseConnectionFileManager_parent_is_not_directory, (Throwable)BaseConnectionFileManager.initFileNotFoundException(path, null)));
                    }
                    this.createDirectory(this.basePath.append(path), Policy.subMonitorFor(monitor, 1));
                } else if (path.segmentCount() == 1) {
                    this.createDirectory(this.basePath.append(path), Policy.subMonitorFor(monitor, 1));
                } else {
                    IProgressMonitor subMonitor = Policy.subMonitorFor(monitor, 1);
                    subMonitor.beginTask(Messages.BaseConnectionFileManager_creating_folders, path.segmentCount());
                    int i = path.segmentCount() - 1;
                    while (i >= 0) {
                        this.createDirectory(this.basePath.append(path).removeLastSegments(i), subMonitor);
                        subMonitor.worked(1);
                        --i;
                    }
                    subMonitor.done();
                }
                this.setLastOperationTime();
            }
            catch (FileNotFoundException e) {
                this.setLastOperationTime();
                throw new CoreException((IStatus)new Status(4, "com.aptana.core.io", Messages.BaseConnectionFileManager_parent_doesnt_exist, BaseConnectionFileManager.initFileNotFoundException(path, e).getCause()));
            }
        }
        finally {
            ProgressMonitorInterrupter.setCurrentThreadInterruptDelegate(null);
            monitor.done();
        }
    }

    public final synchronized void putInfo(IPath path, IFileInfo info, int options, IProgressMonitor monitor) throws CoreException {
        monitor = Policy.monitorFor(monitor);
        monitor.beginTask(MessageFormat.format(Messages.BaseConnectionFileManager_putting_changes, path.toPortableString()), 5);
        try {
            try {
                ProgressMonitorInterrupter.setCurrentThreadInterruptDelegate((ProgressMonitorInterrupter.InterruptDelegate)this.interruptDelegate);
                this.testOrConnect(monitor);
                if ((options & 0x800) != 0) {
                    this.setModificationTime(this.basePath.append(path), info.getLastModified(), Policy.subMonitorFor(monitor, 1));
                    this.setLastOperationTime();
                }
                if ((options & 0x400) != 0 && (options & 0x10000) == 0) {
                    ExtendedFileInfo fileInfo = this.fetchAndCacheFileInfo(path, Policy.subMonitorFor(monitor, 1));
                    if (fileInfo.exists()) {
                        long permissions = fileInfo.getPermissions();
                        permissions = !info.getAttribute(2) ? (permissions |= 0x80L) : (permissions &= 0xFFFFFFFFFFFFFF7FL);
                        permissions = info.getAttribute(4) ? (permissions |= 0x40L) : (permissions &= 0xFFFFFFFFFFFFFFBFL);
                        this.changeFilePermissions(this.basePath.append(path), permissions, Policy.subMonitorFor(monitor, 1));
                    }
                    this.setLastOperationTime();
                }
                if (info instanceof IExtendedFileInfo) {
                    IExtendedFileInfo extInfo = (IExtendedFileInfo)info;
                    if ((options & 0x10000) != 0) {
                        this.changeFilePermissions(this.basePath.append(path), extInfo.getPermissions(), Policy.subMonitorFor(monitor, 1));
                    }
                    if ((options & 0x20000) != 0) {
                        this.changeFileGroup(this.basePath.append(path), extInfo.getGroup(), Policy.subMonitorFor(monitor, 1));
                    }
                    this.setLastOperationTime();
                }
            }
            catch (FileNotFoundException e) {
                this.setLastOperationTime();
                throw new CoreException((IStatus)new Status(4, "com.aptana.core.io", Messages.BaseConnectionFileManager_no_such_file, (Throwable)BaseConnectionFileManager.initFileNotFoundException(path, e.getCause())));
            }
        }
        finally {
            ProgressMonitorInterrupter.setCurrentThreadInterruptDelegate(null);
            this.clearCache(path);
            monitor.done();
        }
    }

    public final synchronized void move(IPath sourcePath, IPath destinationPath, int options, IProgressMonitor monitor) throws CoreException {
        monitor = Policy.monitorFor(monitor);
        monitor.beginTask(MessageFormat.format(Messages.BaseConnectionFileManager_moving, sourcePath.toPortableString()), 5);
        try {
            try {
                ProgressMonitorInterrupter.setCurrentThreadInterruptDelegate((ProgressMonitorInterrupter.InterruptDelegate)this.interruptDelegate);
                this.testOrConnect(monitor);
                ExtendedFileInfo fileInfo = this.fetchAndCacheFileInfo(sourcePath, 2048, Policy.subMonitorFor(monitor, 1));
                this.setLastOperationTime();
                if (!fileInfo.exists()) {
                    throw new CoreException((IStatus)new Status(4, "com.aptana.core.io", Messages.BaseConnectionFileManager_no_such_file, (Throwable)BaseConnectionFileManager.initFileNotFoundException(sourcePath, null)));
                }
                boolean isDirectory = fileInfo.isDirectory();
                fileInfo = this.fetchAndCacheFileInfo(destinationPath, 2048, Policy.subMonitorFor(monitor, 1));
                this.setLastOperationTime();
                if (fileInfo.exists()) {
                    if ((options & 2) == 0) {
                        throw new CoreException((IStatus)new Status(4, "com.aptana.core.io", Messages.BaseConnectionFileManager_file_already_exists, (Throwable)BaseConnectionFileManager.initFileNotFoundException(destinationPath, null)));
                    }
                    if (fileInfo.isDirectory() != isDirectory) {
                        throw new CoreException((IStatus)new Status(4, "com.aptana.core.io", Messages.BaseConnectionFileManager_cant_move));
                    }
                } else {
                    try {
                        this.changeCurrentDir(this.basePath.append(destinationPath).removeLastSegments(1));
                    }
                    catch (FileNotFoundException e) {
                        this.setLastOperationTime();
                        throw new CoreException((IStatus)new Status(4, "com.aptana.core.io", Messages.BaseConnectionFileManager_parent_doesnt_exist, (Throwable)BaseConnectionFileManager.initFileNotFoundException(destinationPath, e.getCause())));
                    }
                    catch (Exception e) {
                        throw new CoreException((IStatus)new Status(4, "com.aptana.core.io", Messages.BaseConnectionFileManager_failed_change_directory, (Throwable)BaseConnectionFileManager.initFileNotFoundException(destinationPath, null)));
                    }
                }
                this.clearCache(sourcePath);
                this.clearCache(destinationPath);
                if (isDirectory) {
                    this.renameDirectory(this.basePath.append(sourcePath), this.basePath.append(destinationPath), Policy.subMonitorFor(monitor, 2));
                } else {
                    this.renameFile(this.basePath.append(sourcePath), this.basePath.append(destinationPath), Policy.subMonitorFor(monitor, 2));
                }
                this.setLastOperationTime();
            }
            catch (FileNotFoundException e) {
                this.setLastOperationTime();
                throw new CoreException((IStatus)new Status(4, "com.aptana.core.io", Messages.BaseConnectionFileManager_no_such_file, (Throwable)BaseConnectionFileManager.initFileNotFoundException(sourcePath, e.getCause())));
            }
        }
        finally {
            ProgressMonitorInterrupter.setCurrentThreadInterruptDelegate(null);
            monitor.done();
        }
    }

    protected abstract void testConnection(boolean var1);

    protected abstract boolean canUseTemporaryFile(IPath var1, ExtendedFileInfo var2, IProgressMonitor var3);

    protected abstract void changeCurrentDir(IPath var1) throws Exception, IOException, CoreException;

    protected abstract ExtendedFileInfo fetchFile(IPath var1, int var2, IProgressMonitor var3) throws CoreException, FileNotFoundException, PermissionDeniedException;

    protected abstract ExtendedFileInfo[] fetchFiles(IPath var1, int var2, IProgressMonitor var3) throws CoreException, FileNotFoundException, PermissionDeniedException;

    protected abstract String[] listDirectory(IPath var1, IProgressMonitor var2) throws CoreException, FileNotFoundException;

    protected abstract InputStream readFile(IPath var1, IProgressMonitor var2) throws CoreException, FileNotFoundException;

    protected abstract OutputStream writeFile(IPath var1, boolean var2, long var3, IProgressMonitor var5) throws CoreException, FileNotFoundException;

    protected abstract void createFile(IPath var1, IProgressMonitor var2) throws CoreException, FileNotFoundException, PermissionDeniedException;

    protected abstract void createDirectory(IPath var1, IProgressMonitor var2) throws CoreException, FileNotFoundException;

    protected abstract void renameFile(IPath var1, IPath var2, IProgressMonitor var3) throws CoreException, FileNotFoundException;

    protected abstract void renameDirectory(IPath var1, IPath var2, IProgressMonitor var3) throws CoreException, FileNotFoundException;

    protected abstract void deleteFile(IPath var1, IProgressMonitor var2) throws CoreException, FileNotFoundException;

    protected abstract void deleteDirectory(IPath var1, IProgressMonitor var2) throws CoreException, FileNotFoundException;

    protected abstract void setModificationTime(IPath var1, long var2, IProgressMonitor var4) throws CoreException, FileNotFoundException;

    protected abstract void changeFilePermissions(IPath var1, long var2, IProgressMonitor var4) throws CoreException, FileNotFoundException;

    protected abstract void changeFileGroup(IPath var1, String var2, IProgressMonitor var3) throws CoreException, FileNotFoundException;

    protected final ExtendedFileInfo[] fetchFilesInternal(IPath path, int options, IProgressMonitor monitor) throws CoreException, FileNotFoundException, PermissionDeniedException {
        MultiStatus multiStatus = null;
        boolean force = false;
        int trial = 0;
        while (trial <= 2) {
            try {
                this.testOrConnect(force, Policy.subMonitorFor(monitor, 1));
                return this.fetchFiles(path, options, monitor);
            }
            catch (CoreException e) {
                IStatus[] childStatus;
                IStatus status = e.getStatus();
                if (multiStatus == null) {
                    multiStatus = new MultiStatus(status.getPlugin(), status.getCode(), status.getMessage(), null);
                }
                if ((childStatus = multiStatus.getChildren()).length < 1 || !childStatus[childStatus.length - 1].getException().getClass().isInstance(status.getException())) {
                    multiStatus.add(status);
                }
                force = e.getCause() instanceof IOException || trial > 0;
                ++trial;
            }
        }
        throw new CoreException(multiStatus);
    }

    protected final ExtendedFileInfo fetchFileInternal(IPath path, int options, IProgressMonitor monitor) throws CoreException, FileNotFoundException, PermissionDeniedException {
        MultiStatus multiStatus = null;
        boolean force = false;
        int trial = 0;
        while (trial <= 2) {
            try {
                this.testOrConnect(force, Policy.subMonitorFor(monitor, 1));
                return this.fetchFile(path, options, monitor);
            }
            catch (CoreException e) {
                IStatus[] childStatus;
                IStatus status = e.getStatus();
                if (multiStatus == null) {
                    multiStatus = new MultiStatus(status.getPlugin(), status.getCode(), status.getMessage(), null);
                }
                if ((childStatus = multiStatus.getChildren()).length < 1 || !childStatus[childStatus.length - 1].getException().getClass().isInstance(status.getException())) {
                    multiStatus.add(status);
                }
                force = e.getCause() instanceof IOException || trial > 0;
                ++trial;
            }
        }
        throw new CoreException(multiStatus);
    }

    private ExtendedFileInfo fetchAndCacheFileInfo(IPath path, IProgressMonitor monitor) throws CoreException {
        return this.fetchAndCacheFileInfo(path, 0, monitor);
    }

    private ExtendedFileInfo fetchAndCacheFileInfo(IPath path, int options, IProgressMonitor monitor) throws CoreException {
        ExtendedFileInfo fileInfo;
        try {
            fileInfo = this.fetchFileInternal(this.basePath.append(path), options, monitor);
        }
        catch (FileNotFoundException e) {
            ExtendedFileInfo fileInfo2 = new ExtendedFileInfo(path.segmentCount() > 0 ? path.lastSegment() : Path.ROOT.toPortableString());
            fileInfo2.setExists(false);
            return fileInfo2;
        }
        catch (PermissionDeniedException e) {
            throw new CoreException((IStatus)new Status(4, "com.aptana.core.io", MessageFormat.format(Messages.BaseConnectionFileManager_PermissionDenied0, this.basePath.append(path).toPortableString()), (Throwable)e));
        }
        if (path.segmentCount() == 0) {
            fileInfo.setName(Path.ROOT.toPortableString());
        }
        this.postProcessFileInfo(fileInfo, path, options, monitor);
        return this.cache(path, fileInfo);
    }

    private void postProcessFileInfo(ExtendedFileInfo fileInfo, IPath dirPath, int options, IProgressMonitor monitor) throws CoreException {
        long permissions;
        if (fileInfo.getAttribute(32)) {
            try {
                ExtendedFileInfo targetFileInfo = this.resolveSymlink(dirPath, fileInfo.getStringAttribute(64), options, monitor);
                fileInfo.setExists(targetFileInfo.exists());
                if (!targetFileInfo.exists()) {
                    throw new FileNotFoundException(fileInfo.getName());
                }
                fileInfo.setDirectory(targetFileInfo.isDirectory());
                fileInfo.setLength(targetFileInfo.getLength());
                fileInfo.setLastModified(targetFileInfo.getLastModified());
                fileInfo.setOwner(targetFileInfo.getOwner());
                fileInfo.setGroup(targetFileInfo.getGroup());
                fileInfo.setPermissions(targetFileInfo.getPermissions());
            }
            catch (FileNotFoundException e) {
                try {
                    this.changeCurrentDir(dirPath.append(fileInfo.getName()));
                    fileInfo.setExists(true);
                    fileInfo.setDirectory(true);
                }
                catch (FileNotFoundException fnfe) {
                    fileInfo.setExists(false);
                }
                catch (Exception ignore) {
                    IdeLog.logWarning((Plugin)CoreIOPlugin.getDefault(), (String)Messages.BaseConnectionFileManager_symlink_resolve_failed, (Throwable)e);
                }
            }
        }
        fileInfo.setAttribute(2, ((permissions = fileInfo.getPermissions()) & 0x80L) == 0L);
        fileInfo.setAttribute(4, (permissions & 0x40L) != 0L);
    }

    private ExtendedFileInfo resolveSymlink(IPath dirPath, String linkTarget, int options, IProgressMonitor monitor) throws CoreException, FileNotFoundException {
        HashSet<IPath> visited = new HashSet<IPath>();
        visited.add(dirPath);
        while (linkTarget != null && linkTarget.length() > 0) {
            IPath targetPath = Path.fromPortableString((String)linkTarget);
            if (!targetPath.isAbsolute()) {
                targetPath = dirPath.append(targetPath);
            }
            if (visited.contains(targetPath)) break;
            visited.add(targetPath);
            ExtendedFileInfo targetFileInfo = this.getCachedFileInfo(targetPath);
            if (targetFileInfo == null) {
                Policy.checkCanceled(monitor);
                try {
                    targetFileInfo = this.cache(targetPath, this.fetchFileInternal(targetPath, options, Policy.subMonitorFor(monitor, 1)));
                }
                catch (PermissionDeniedException e) {
                    throw BaseConnectionFileManager.initFileNotFoundException(targetPath, e);
                }
            }
            this.cache(targetPath, targetFileInfo);
            if (targetFileInfo.getAttribute(32)) {
                linkTarget = targetFileInfo.getStringAttribute(64);
                dirPath = targetPath.removeLastSegments(1);
                continue;
            }
            return targetFileInfo;
        }
        return new ExtendedFileInfo();
    }

    private final ExtendedFileInfo getCachedFileInfo(IPath path) {
        return this.fileInfoCache != null ? this.fileInfoCache.get(path) : null;
    }

    private final ExtendedFileInfo[] getCachedFileInfos(IPath path) {
        return this.fileInfosCache != null ? this.fileInfosCache.get(path) : null;
    }

    private final ExtendedFileInfo cache(IPath path, ExtendedFileInfo fileInfo) {
        if (this.fileInfoCache != null && fileInfo.exists()) {
            this.fileInfoCache.put(path, fileInfo);
        }
        return fileInfo;
    }

    private final ExtendedFileInfo[] cache(IPath path, ExtendedFileInfo[] fileInfos) {
        if (this.fileInfosCache != null) {
            this.fileInfosCache.put(path, fileInfos);
        }
        return fileInfos;
    }

    protected void clearCache(IPath path) {
        int segments = path.segmentCount();
        if (this.fileInfoCache != null) {
            for (IPath p : new ArrayList<IPath>(this.fileInfoCache.keySet())) {
                if (p.segmentCount() < segments || path.matchingFirstSegments(p) != segments) continue;
                this.fileInfoCache.remove(p);
            }
        }
        if (this.fileInfosCache != null) {
            for (IPath p : new ArrayList<IPath>(this.fileInfosCache.keySet())) {
                if (p.segmentCount() < segments || path.matchingFirstSegments(p) != segments) continue;
                this.fileInfosCache.remove(p);
            }
        }
    }

    protected final void cleanup() {
        if (this.fileInfoCache != null) {
            this.fileInfoCache.clear();
        }
        if (this.fileInfosCache != null) {
            this.fileInfosCache.clear();
        }
    }

    protected void interruptOperation() {
        Thread.currentThread().interrupt();
    }

    protected void setLastOperationTime() {
    }

    protected final void testOrConnect(IProgressMonitor monitor) throws CoreException {
        this.testOrConnect(false, monitor);
    }

    protected final void testOrConnect(boolean force, IProgressMonitor monitor) throws CoreException {
        Policy.checkCanceled(monitor);
        this.testConnection(force);
        if (!this.isConnected()) {
            this.connect(Policy.subMonitorFor(monitor, 1));
            Policy.checkCanceled(monitor);
        }
    }

    protected static FileNotFoundException initFileNotFoundException(IPath path, Throwable cause) {
        FileNotFoundException e = new FileNotFoundException(path.toPortableString());
        if (cause != null) {
            e.initCause(cause);
        }
        return e;
    }
}

